<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/SezioneSdoppiata.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new SezioneSdoppiata($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new SezioneSdoppiata($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $usaParallax = (isset($_POST["usaParallax"]) && $_POST["usaParallax"]=="si") ? "si" : "no";
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING));
            $occorrenza->setProporzioni(filter_input(INPUT_POST,"proporzioni",FILTER_SANITIZE_STRING));
            $occorrenza->setAltezza(filter_input(INPUT_POST,"altezza",FILTER_SANITIZE_STRING));
            $occorrenza->setDoveSiTrovaImmagine(filter_input(INPUT_POST,"doveSiTrovaImmagine",FILTER_SANITIZE_STRING));
            $occorrenza->setDoveSiTrovaImmagineSuMobile(filter_input(INPUT_POST,"doveSiTrovaImmagineSuMobile",FILTER_SANITIZE_STRING));
            $occorrenza->setUsaParallax($usaParallax);
            $occorrenza->setAnimazioneTesto(filter_input(INPUT_POST,"animazioneTesto",FILTER_SANITIZE_STRING));
            $occorrenza->setClasseDivTesto(filter_input(INPUT_POST,"classeDivTesto",FILTER_SANITIZE_STRING));
            $occorrenza->setColoreDivTesto(filter_input(INPUT_POST,"coloreDivTesto",FILTER_SANITIZE_STRING));
            $occorrenza->setStileImmagine(filter_input(INPUT_POST,"stileImmagine",FILTER_SANITIZE_STRING));
            $occorrenza->setAnimazioneImmagine(filter_input(INPUT_POST,"animazioneImmagine",FILTER_SANITIZE_STRING));
            $occorrenza->setClasseDivImmagine(filter_input(INPUT_POST,"classeImmagineTesto",FILTER_SANITIZE_STRING));
            $occorrenza->crea();
            header("Location: ../creaSezione.php?id={$occorrenza->getId()}&status=200");
            break;
        case 'modifica':
            $usaParallax = (isset($_POST["usaParallax"]) && $_POST["usaParallax"]=="si") ? "si" : "no";
            $occorrenza->caricaDatiDalDatabase();
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $occorrenza->setProporzioni(filter_input(INPUT_POST,"proporzioni",FILTER_SANITIZE_STRING));
            $occorrenza->setAltezza(filter_input(INPUT_POST,"altezza",FILTER_SANITIZE_STRING));
            $occorrenza->setDoveSiTrovaImmagine(filter_input(INPUT_POST,"doveSiTrovaImmagine",FILTER_SANITIZE_STRING));
            $occorrenza->setDoveSiTrovaImmagineSuMobile(filter_input(INPUT_POST,"doveSiTrovaImmagineSuMobile",FILTER_SANITIZE_STRING));
            $occorrenza->setUsaParallax($usaParallax);
            $occorrenza->setTesto(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setAnimazioneTesto(filter_input(INPUT_POST,"animazioneTesto",FILTER_SANITIZE_STRING));
            $occorrenza->setClasseDivTesto(filter_input(INPUT_POST,"classeDivTesto",FILTER_SANITIZE_STRING));
            $occorrenza->setColoreDivTesto(filter_input(INPUT_POST,"coloreDivTesto",FILTER_SANITIZE_STRING));
            $occorrenza->setStileImmagine(filter_input(INPUT_POST,"stileImmagine",FILTER_SANITIZE_STRING));
            $occorrenza->setAnimazioneImmagine(filter_input(INPUT_POST,"animazioneImmagine",FILTER_SANITIZE_STRING));
            $occorrenza->setClasseDivImmagine(filter_input(INPUT_POST,"classeImmagineTesto",FILTER_SANITIZE_STRING));
            $occorrenza->setTagAltImmagine(filter_input(INPUT_POST,"tagAltImmagine",FILTER_SANITIZE_STRING));
            $occorrenza->modifica();
            header("Location: ../creaSezione.php?id={$occorrenza->getId()}&status=250");
            break;
        case 'modificaImmagine':
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $occorrenza->cambiaImmagine($percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'elimina':
            $occorrenza->elimina();
            echo "ok";
            break;
        case 'eliminaImmagine':
            $occorrenza->cambiaImmagine('');
            echo "ok";
            break;
        case 'modificaImmagineOccorrenzaConPercorso':
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $occorrenza->cambiaImmagine($percorso);
            echo "ok";
            break;
        case 'duplica':
            $occorrenza->caricaDatiDalDatabase();
            $idNuovaForm = $occorrenza->duplica();
            header("Location: ../creaSezione.php?id={$idNuovaForm}&status=260");
            break;
    }
